# Dhii - Normalization Helper Base

[![Build Status](https://travis-ci.org/Dhii/normalization-helper-base.svg?branch=master)](https://travis-ci.org/Dhii/normalization-helper-base)
[![Code Climate](https://codeclimate.com/github/Dhii/normalization-helper-base/badges/gpa.svg)](https://codeclimate.com/github/Dhii/normalization-helper-base)
[![Test Coverage](https://codeclimate.com/github/Dhii/normalization-helper-base/badges/coverage.svg)](https://codeclimate.com/github/Dhii/normalization-helper-base/coverage)
[![Latest Stable Version](https://poser.pugx.org/dhii/normalization-helper-base/version)](https://packagist.org/packages/dhii/normalization-helper-base)
[![This package complies with Dhii standards](https://img.shields.io/badge/Dhii-Compliant-green.svg?style=flat-square)][Dhii]

Functionality for normalizing values.

## Traits
- [`NormalizeArrayCapableTrait`][NormalizeArrayCapableTrait] - Normalize something iterable into an array.
- [`NormalizeIntCapableTrait`][NormalizeIntCapableTrait] - Normalize a number representation into an integer.
- [`NormalizeIterableCapableTrait`][NormalizeIterableCapableTrait] - Normalize a value to something iterable.
- [`NormalizeStringCapableTrait`][NormalizeStringCapableTrait] - Normalize a string representation into a string.
- [`NormalizeStringableCapableTrait`] - Normalize a value to something that can be converted to string in a meaningful way.


[Dhii]: https://github.com/Dhii/dhii

[NormalizeArrayCapableTrait]:                           src/NormalizeArrayCapableTrait.php
[NormalizeIntCapableTrait]:                             src/NormalizeIntCapableTrait.php
[NormalizeIterableCapableTrait]:                        src/NormalizeIterableCapableTrait.php
[NormalizeStringCapableTrait]:                          src/NormalizeStringCapableTrait.php
[`NormalizeStringableCapableTrait`]:                    src/NormalizeStringableCapableTrait.php
