const { __ } = wp.i18n;

export const optionsOrderby = [
  { value: 'name', label: __('Name') },
  { value: 'natural', label: __('Natural sorting') },
  { value: 'count', label: __('Post count') },
  { value: 'slug', label: __('Slug') },
  { value: 'term_id', label: __('Term ID') },
  { value: 'description', label: __('Description') },
  { value: 'random', label: __('Random') },
  { value: 'term_order', label: __('Term Order') },
];

export const optionsOrder = [
  { value: 'ASC', label: __('Ascending') },
  { value: 'DESC', label: __('Descending') },
];

export const optionsTarget = [
  { value: '_self', label: '_self' },
  { value: '_blank', label: '_blank' },
  { value: '_parent', label: '_parent' },
  { value: '_top', label: '_top' },
]

export function getIncludeOptions(_this) {
  let optionsInclude = [];

  if (_this.state.groups && _this.state.groups.length > 0) {
    _this.state.groups.forEach((group) => {
      optionsInclude.push({ value: group.term_group, label: group.label });
    });
  }
  return optionsInclude;
}

export function getExcludeOptions(_this) {
  let optionsExclude = [];

  if (_this.state.groups && _this.state.groups.length > 0) {
    _this.state.groups.forEach((group) => {
      if (_this.state.selectedInclude.indexOf(group.term_group) < 0) {
        optionsExclude.push({ value: group.term_group, label: group.label });
      }
    });
  }
  return optionsExclude;
}

export function getTaxonomyOptions(_this) {
  let optionsTaxonomies = [];

  if (_this.state.taxonomies && _this.state.taxonomies.length > 0) {
    _this.state.taxonomies.forEach((taxonomy) => {
      optionsTaxonomies.push({ value: taxonomy.slug, label: taxonomy.name });
    });
  }
  return optionsTaxonomies;
}

export function getActiveGroupsOptions(_this) {
  const { groups_post_id } = _this.props.attributes;
  let optionsActiveGroups = [];

  let i = 0;
  if (_this.state.selectedInclude && _this.state.selectedInclude.length) {
    _this.state.groups.forEach((group) => {
      if (_this.state.selectedInclude.indexOf(group.term_group) > -1) {
        let label;
        if (groups_post_id > -1) {
          label = i;
        } else {
          label = group.label;
        }
        optionsActiveGroups.push({ value: i, label });
        i++;
      }
    });
  } else if (_this.state.groups && _this.state.groups.length) {
    _this.state.groups.forEach((group) => {
      if (!group.term_group) return; // skipping unassigned
      let label;
      if (groups_post_id > -1) {
        label = i;
      } else {
        label = group.label;
      }
      optionsActiveGroups.push({ value: i, label });
      i++;
    });
  }
  return optionsActiveGroups;
}

export function renderTabs(_this) {
  const { active, collapsible, mouseover } = _this.props.attributes;

  let options = {
    active: active < 0 ? false : active,
    collapsible: collapsible == 1,
  };

  if (mouseover) {
    options.event = 'mouseover';
  }

  setTimeout(() => {
    jQuery('#' + _this.state.uniqueId).tabs(options);
  }, 1000);
}

export function renderAccordion(_this) {
  const {
    active,
    collapsible,
    mouseover,
    heightstyle,
  } = _this.props.attributes;

  let options = {
    active: active < 0 ? false : active,
    collapsible: collapsible == 1,
    heightStyle: heightstyle,
  };

  if (mouseover) {
    options.event = 'mouseover';
  }

  setTimeout(() => {
    jQuery('#' + _this.state.uniqueId).accordion(options);
  }, 1000);
}
