<?php 



function wpb_bls_slider_trigger(){
?>
<script type="text/javascript">
jQuery(document).ready(function(){
  jQuery('.wpb_logo_slider').owlCarousel({
 
      autoPlay: false, //Set AutoPlay to 3 seconds
      items : 5,
      itemsDesktopSmall : [979,4],
      itemsTablet : [768,3],
      itemsMobile : [479,1],
      paginationSpeed : 800,
      stopOnHover : true,
      navigation : true,
      pagination : true,
	  slideSpeed : 1000,
	  navigationText : ["<",">"],
 
  });
});
</script>
<?php
}
add_action('wp_footer','wpb_bls_slider_trigger');

//--------- Best Logo slider Shortcode---------------- //

// Add Shortcode
function wpb_bls_shortcode( $atts ) {

	// Attributes
	extract( shortcode_atts(
		array(
			'posts' => "-1",
			'order' => '',
			'orderby' => '',
			'title' => 'yes',
		), $atts )
	);
	
	
	$return_string = '<div id="wpb_logo_slider" class="wpb_logo_slider">';
	
	query_posts(array('orderby' => 'date', 'order' => 'DESC' , 'showposts' => $posts, 'post_type' => 'logo_slider'));
		if (have_posts()) :
			while (have_posts()) : the_post();
				$post_id = get_the_ID();
				$logo_id = get_post_thumbnail_id();
				$logo_url = wp_get_attachment_image_src($logo_id,'full',true);
				$logo_mata = get_post_meta($logo_id,'_wp_attachment_image_alt',true);
				$logo = aq_resize( $logo_url[0], 220, 100, true );
				// Client Link
				$logo_link = get_post_meta( $post_id, 'wpb_bls_logo_class', true );
				
				$return_string .= '<div class="logo_item">';
				if($logo_link) : 
				$return_string .= '<a href="'.$logo_link.'">'; // client url
				endif;
				$return_string .= '<img src="'. $logo .'" alt="'. $logo_mata .'" />';
				if($logo_link) :
				$return_string .= '</a>'; // client url end
				endif;
				if($title == "yes"):
				$return_string .= '<h4 class="wpb_logo_title">'. get_the_title() .'</h4>';
				endif;
				$return_string .= '</div>';
			endwhile;
		endif;
	$return_string .= '</div>';

	wp_reset_query();
	
	return $return_string;
}
add_shortcode( 'logo-slider', 'wpb_bls_shortcode' );

//--------- Logo Post type ---------------- //
// Register Custom Post Type
function wpb_bls_post_type() {

	$labels = array(
		'name'                => _x( 'Logo Slider', 'Post Type General Name', 'wpbean' ),
		'singular_name'       => _x( 'Logo Slider', 'Post Type Singular Name', 'wpbean' ),
		'menu_name'           => __( 'Logo Slider', 'wpbean' ),
		'parent_item_colon'   => __( 'Parent Logo :', 'wpbean' ),
		'all_items'           => __( 'All Logos', 'wpbean' ),
		'view_item'           => __( 'View Logo ', 'wpbean' ),
		'add_new_item'        => __( 'Add New Logo ', 'wpbean' ),
		'add_new'             => __( 'Add New Logo', 'wpbean' ),
		'edit_item'           => __( 'Edit Logo ', 'wpbean' ),
		'update_item'         => __( 'Update Logo ', 'wpbean' ),
		'search_items'        => __( 'Search Logo ', 'wpbean' ),
		'not_found'           => __( 'Not found', 'wpbean' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'wpbean' ),
	);
	$args = array(
		'label'               => __( 'logo_slider', 'wpbean' ),
		'description'         => __( 'Logo Slider post type.', 'wpbean' ),
		'labels'              => $labels,
		'supports'            => array( 'title', 'thumbnail', ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'menu_position'       => 80,
		'menu_icon'           => 'dashicons-images-alt',
		'can_export'          => true,
		'has_archive'         => true,
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'page',
	);
	register_post_type( 'logo_slider', $args );

}

// Hook into the 'init' action
add_action( 'init', 'wpb_bls_post_type', 0 );